<?php
namespace LiquidElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class LQD_Scroll_Progress extends Widget_Base {

	public function get_name() {
		return 'lqd-scroll-progress';
	}

	public function get_title() {
		return __( 'Liquid Scroll Progress', 'logistics-hub-core' );
	}

	public function get_icon() {
		return 'eicon-scroll lqd-element';
	}

	public function get_categories() {
		return [ 'liquid-core' ];
	}

	public function get_keywords() {
		return [ 'scroll', 'progress' ];
	}

	public function get_behavior() {
		$settings = $this->get_settings_for_display();
		$behavior = [];

		$behavior[] = [
			'behaviorClass' => 'LiquidLocalScrollBehavior',
		];

		$behavior[] = [
			'behaviorClass' => 'LiquidAnimationsBehavior',
			'options' => [
				'domain' => "'parallax'",
				'ease' => "'linear'",
				'trigger' => "'#lqd-wrap'",
				'start' => "'top top'",
				'end' => "'max'",
				'scrub' => 'true',
				'animations' => [[
					[
						'breakpointsKeyframes' => [
							'all' => [
								'keyframes' => [[
									[ 'scaleY' => 1 ]
								]],
							],
						]
					]
				]]
			]
		];

		if ( $settings['lqd_adaptive_color'] === 'yes' ) {
			$behavior[] = [
				'behaviorClass' => 'LiquidGetElementComputedStylesBehavior',
				'options' => [
					'getRect' => 'true',
					'includeSelf' => 'true',
					'getStyles' => ["'position'"],
				]
			];
			$behavior[] = [
				'behaviorClass' => 'LiquidAdaptiveColorBehavior',
			];
		}

		return $behavior;
	}

	public function get_behavior_pageContent() {
		$settings = $this->get_settings_for_display();
		$adaptive_color = $settings['lqd_adaptive_color'];
		$behavior = [];

		if ( !$adaptive_color ){
			return $behavior;
		}

		$behavior[] = [
			'behaviorClass' => 'LiquidGetElementComputedStylesBehavior',
			'options' => [
				'includeChildren' => true,
				'includeSelf' => true,
				'getOnlyContainers' => true,
				'getStyles' => ["'backgroundColor'"],
				'getBrightnessOf' => ["'backgroundColor'"],
				'getRect' => true
			]
		];

		return $behavior;
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => __( 'General', 'logistics-hub-core' ),
			]
		);

		$this->add_control(
			'text',
			[
				'label' => __( 'Text', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'scroll to top', 'logistics-hub-core' ),
				'placeholder' => __( 'scroll to top', 'logistics-hub-core' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'effects',
			[
				'label' => __( 'Effects <span style="font-size: 1.5em; vertical-align:middle; margin-inline-start:0.35em;">⚡️<span>', 'logistics-hub-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'lqd_adaptive_color',
			[
				'label' => esc_html__( 'Enable adaptive color?', 'logistics-hub-core' ),
				'description' => esc_html__( 'Useful for elements with fixed css position or when inside sticky header. This option make the element chage color dynamically when it is over light or dark sections.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

		\LQD_Elementor_Helper::add_style_controls(
			$this,
			'scroll-progress',
			[
				'link' => [
					'label' => 'General',
					'controls' => [
						[
							'type' => 'typography',
						],
						[
							'type' => 'liquid_color',
							'css_var' => '--lqd-scrl-prg-c',
						],
					],
					'plural_heading' => false,
					'state_tabs' => [ 'normal', 'hover' ],
					'state_selectors_before' => [ 'hover' => '{{WRAPPER}}' ]
				],
				'progress_bar' => [
					'controls' => [
						[
							'type' => 'width',
							'css_var' => '--lqd-scrl-prg-w'
						],
						[
							'type' => 'height',
							'css_var' => '--lqd-scrl-prg-h'
						],
						[
							'type' => 'liquid_background_css',
							'name' => 'progress_bg',
							'css_var' => '--lqd-scrl-prg-bg',
						],
						[
							'type' => 'liquid_background_css',
							'name' => 'progress_el_bg',
							'css_var' => '--lqd-scrl-prg-el-bg',
							'fields_options' => [
								'background' => [
									'label' => esc_html__( 'Fill background', 'logistics-hub-core' ),
								],
							],
						],
						[
							'type' => 'border_radius',
							'css_var' => '--lqd-scrl-prg-brr'
						],
					],
					'plural_heading' => false,
					'state_tabs' => [ 'normal', 'hover' ],
					'state_selectors_before' => [ 'hover' => '{{WRAPPER}}' ]
				],
			],
		);

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

        ?>

		<a href="#lqd-wrap" class="lqd-scroll-progress-link flex items-center gap-20 whitespace-nowrap lqd-text-vertical transition-all text-inherit leading-none" data-lqd-local-scroll-el>
			<span class="lqd-scroll-progress-bar grow relative inline-block overflow-hidden">
				<span class="lqd-scroll-progress-bg inline-block absolute bottom-0 start-0 w-full h-full rounded-inherit bg-current opacity-30"></span>
				<span class="lqd-scroll-progress-el inline-block absolute bottom-0 start-0 w-full h-full rounded-inherit bg-current origin-center-top lqd-transform scale-y-0" data-lqd-animation-el></span>
			</span>
			<span class="lqd-scroll-progress-txt"><?php echo esc_html( $settings['text'] ) ?></span>
		</a>

        <?php

	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new LQD_Scroll_Progress() );